<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Validador de Cédula Ecuatoriana</title>
  <style>
    body{
      font-family:'Segoe UI',Tahoma,sans-serif;
      background:linear-gradient(135deg,#6a11cb,#2575fc,#00b4db);
      color:#fff;
      margin:0;
      padding:40px;
      display:flex;
      align-items:center;
      justify-content:center;
      height:100vh;
    }
    .container{
      background:linear-gradient(160deg,rgba(255,255,255,0.15),rgba(255,255,255,0.05));
      padding:30px;
      border-radius:12px;
      text-align:center;
      max-width:600px;
      width:100%;
      box-shadow:0 8px 30px rgba(0,0,0,0.35);
      backdrop-filter:blur(8px);
    }
    h1{
      font-size:28px;
      margin-bottom:20px;
      background:linear-gradient(90deg,#ff9a9e,#fad0c4);
      -webkit-background-clip:text;
      -webkit-text-fill-color:transparent;
    }
    input{
      width:80%;
      padding:10px;
      border-radius:8px;
      border:none;
      text-align:center;
      font-size:18px;
      background:linear-gradient(90deg,#e0f7fa,#f1f8e9);
      color:#333;
      box-shadow:0 0 10px rgba(255,255,255,0.2);
    }
    button{
      background:linear-gradient(90deg,#ff6a00,#ee0979);
      color:#fff;
      padding:10px 20px;
      border:none;
      border-radius:8px;
      font-weight:700;
      margin-top:15px;
      cursor:pointer;
      transition:transform 0.2s ease,box-shadow 0.2s ease;
      box-shadow:0 4px 15px rgba(0,0,0,0.3);
    }
    button:hover{
      transform:scale(1.05);
      box-shadow:0 6px 20px rgba(0,0,0,0.4);
    }
    img{
      width:220px;
      margin-bottom:15px;
      border-radius:8px;
      box-shadow:0 0 12px rgba(255,255,255,0.4);
    }
  </style>
</head>
<body>
  <div class="container">
    <h1>📍 Ecuador</h1>
    <h2>VALIDADOR DE CEDULA</h2>
    <img class="cedula-img" src="imagen.ci/Cédula_Ecuador.png">
    <form action="resultado.php" method="post">
      <input type="text" name="cedula" maxlength="10" placeholder="Ingrese su número de cédula" required>
      <br>
      <button type="submit">Validar Cédula</button>
    </form>
  </div>
</body>
</html>
