<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Resultado de Validación</title>
  <style>
    body{
      font-family:'Segoe UI',Tahoma,sans-serif;
      background:linear-gradient(135deg,#1a237e,#0d47a1);
      color:#fff;margin:0;padding:40px;
      display:flex;align-items:center;justify-content:center;
      height:100vh;
    }
    .container{
      background:rgba(255,255,255,0.08);
      padding:30px;border-radius:12px;
      max-width:600px;width:100%;text-align:center;
      box-shadow:0 8px 30px rgba(0,0,0,0.35);
    }
    h1{margin:0 0 15px;font-size:26px}
    .valid{
      background:rgba(46,204,113,0.95);color:#062b16;
      padding:15px;border-radius:8px;font-weight:700;display:inline-block
    }
    .invalid{
      background:rgba(231,76,60,0.95);color:#2b0b06;
      padding:15px;border-radius:8px;font-weight:700;display:inline-block
    }
    .btn{
      display:inline-block;margin-top:20px;background:#fff;
      color:#1a237e;padding:10px 20px;border-radius:8px;
      text-decoration:none;font-weight:700;cursor:pointer;
      border:none;
    }
    .btn:hover{background:#e8eaf6}
  </style>
</head>
<body>
  <div class="container">
    <h1>📍 Ecuador</h1>
<?php
$provincias = [
  '01'=>'Azuay','02'=>'Bolívar','03'=>'Cañar','04'=>'Carchi','05'=>'Cotopaxi','06'=>'Chimborazo','07'=>'El Oro',
  '08'=>'Esmeraldas','09'=>'Guayas','10'=>'Imbabura','11'=>'Loja','12'=>'Los Ríos','13'=>'Manabí','14'=>'Morona Santiago',
  '15'=>'Napo','16'=>'Pastaza','17'=>'Pichincha','18'=>'Tungurahua','19'=>'Zamora Chinchipe','20'=>'Galápagos',
  '21'=>'Sucumbíos','22'=>'Orellana','23'=>'Santo Domingo de los Tsáchilas','24'=>'Santa Elena'
];

$cedula = trim($_POST['cedula'] ?? '');

if ($cedula === '' || strlen($cedula) !== 10 || !ctype_digit($cedula)) {
    echo "<div class='invalid'>❌ NO VALIDADA<br>Debe ingresar exactamente 10 números sin letras.</div>";
} else {
    $codigoProvincia = substr($cedula, 0, 2);
    if (isset($provincias[$codigoProvincia])) {
        $provincia = $provincias[$codigoProvincia];
        echo "<div class='valid'>✅ CÉDULA VÁLIDA<br>Número: <strong>$cedula</strong><br>Provincia: <strong>$provincia</strong></div>";
    } else {
        echo "<div class='invalid'>❌ NO VALIDADA<br>El código de provincia ($codigoProvincia) no corresponde a ninguna provincia ecuatoriana.</div>";
    }
}
?>
    <form action="cedula1.php" method="get">
      <button type="submit" class="btn">↩ Regresar al validador</button>
    </form>
  </div>
</body>
</html>